#include "General.h"

AzazelBot::AzazelBot()
{
	RegisterEvent(EVENT_GLOBAL_INI,this);
	RegisterEvent(EVENT_MAP_INI,this);
	RegisterEvent(EVENT_CHAT_HOOK,this);
	RegisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
	RegisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
	RegisterEvent(EVENT_GAME_OVER_HOOK,this);
	RegisterEvent(EVENT_PLAYER_JOIN_HOOK,this);
	RegisterEvent(EVENT_PLAYER_LEAVE_HOOK,this);
	RegisterEvent(EVENT_REFILL_HOOK,this);
	RegisterEvent(EVENT_POWERUP_PURCHASE_HOOK,this);
	RegisterEvent(EVENT_VEHICLE_PURCHASE_HOOK,this);
	RegisterEvent(EVENT_CHARACTER_PURCHASE_HOOK,this);
	RegisterEvent(EVENT_THINK_HOOK,this);
}

AzazelBot::~AzazelBot()
{
	UnregisterEvent(EVENT_GLOBAL_INI,this);
	UnregisterEvent(EVENT_MAP_INI,this);
	UnregisterEvent(EVENT_CHAT_HOOK,this);
	UnregisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
	UnregisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
	UnregisterEvent(EVENT_GAME_OVER_HOOK,this);
	UnregisterEvent(EVENT_PLAYER_JOIN_HOOK,this);
	UnregisterEvent(EVENT_PLAYER_LEAVE_HOOK,this);
	UnregisterEvent(EVENT_REFILL_HOOK,this);
	UnregisterEvent(EVENT_POWERUP_PURCHASE_HOOK,this);
	UnregisterEvent(EVENT_VEHICLE_PURCHASE_HOOK,this);
	UnregisterEvent(EVENT_CHARACTER_PURCHASE_HOOK,this);
	UnregisterEvent(EVENT_THINK_HOOK,this);

	Settings::Unload();
	DB::Unload();
	Player::Unload();
	Commands::Unload();
	IRC::Unload();
}

void AzazelBot::OnLoadGlobalINISettings(INIClass *SSGMIni)
{
	Settings::Load();
	DB::Load();
	Commands::Load();
	Player::Load();
	IRC::Load();

	AddHostHook(Functions::Host_Hook);
	AddPowerupPurchaseMonHook(Functions::Purchase_Mon_Hook, "0");
	AddVehiclePurchaseMonHook(Functions::Purchase_Mon_Hook, "1");
	AddCharacterPurchaseMonHook(Functions::Purchase_Mon_Hook, "2");
	AddPowerupPurchaseHook(Functions::Purchase_Hook,"0");
	AddVehiclePurchaseHook(Functions::Purchase_Hook, "1");
	AddCharacterPurchaseHook(Functions::Purchase_Hook, "2");
	
	Functions::Create_Thread(Functions::Auto_Announce, NULL);
}

void AzazelBot::OnFreeData()
{
}

void AzazelBot::OnLoadMapINISettings(INIClass *SSGMIni)
{
}

void AzazelBot::OnFreeMapData()
{
}

bool AzazelBot::OnChat(int PlayerID,TextMessageEnum Type,const wchar_t *Message,int recieverID)
{
	Player_t* p = Player::Get(PlayerID);

	if(Type == TEXT_MESSAGE_PUBLIC)
	{
		if (p->Muted)
		{
			IRC::SendC(CHAN_ADMIN, "%s%S%s: %S\n", Get_Team(PlayerID) ? YELLOW : RED, Find_Player(PlayerID)->PlayerName, NM, Message);
		}
		else
		{
			IRC::SendC(CHAN_BOTH, "%s%S%s: %S\n", Get_Team(PlayerID) ? YELLOW : RED, Find_Player(PlayerID)->PlayerName, NM, Message);
		}
	}
	else if (Type == TEXT_MESSAGE_TEAM)
	{
		IRC::SendC(CHAN_ADMIN, "%s[Team]%s %s%S%s: %S\n", PURPLE, NM, Get_Team(PlayerID) ? YELLOW : RED, Find_Player(PlayerID)->PlayerName, NM, Message);
	}

	if (Message[0] == L'!')
	{
		if (p->Shunned)
		{
			Functions::Page(PlayerID, "You are shunned, you can no longer use chat commands.");
			return false;
		}
		StringClass Msg = Message;

		GameChat_t* Data = new GameChat_t;
		Data->Message = Msg;
		Data->PlayerID = PlayerID;
		Data->Type = Type;

		Functions::Create_Thread(Commands::Game_Chat, (LPVOID) Data);
	}

	if (p->Muted)
	{
		Functions::Page(PlayerID, "You are muted, you can no longer chat.");
		return false;
	}
	return true;
}

void AzazelBot::OnObjectCreate(void *data,GameObject *obj)
{
	if (Is_Beacon(obj))
	{
		Attach_Script_Once(obj, "AzazelBot_LogBeacon", "");
	}
	else if (Is_Vehicle(obj))
	{
		Attach_Script_Once(obj, "AzazelBot_LogVehicle", "");
	}
	else if (Is_Building(obj))
	{
		Attach_Script_Once(obj, "AzazelBot_LogBuilding", "");
	}
	else if (Commands->Is_A_Star(obj))
	{
		Attach_Script_Once(obj, "AzazelBot_LogPlayer", "");
	}
}

void AzazelBot::OnLoadLevel()
{
	Settings::Load_Map_Rules();
	Player::MapLoad();
	IRC::SendC(CHAN_PUBLIC, "%sLoading level %s", LGREEN, Get_Map(Get_Current_Map_Index()));

}

void AzazelBot::OnGameOver()
{
	Functions::Send_End_Map_Info(The_Game()->Get_Win_Type());

	// add if settings::enableendgamerecs..
/*	if ((The_Game()->Get_Current_Players() > 0) && (Functions::EndGameThreadExists == false))
	{
		Functions::EndGameThreadExists = true;
		D_("1");
		int MostKillsID = Functions::Get_Most_Kills();
		D_("2");
		int BestKDID = Functions::Get_Best_KD();
		D_("3");
		int HighestScoreID = Functions::Get_Highest_Score();
		D_("4");
		EndGameRecs_t* Data = new EndGameRecs_t;
		D_("5");
		Data->MapName = Get_Map(Get_Current_Map_Index());
		D_("6");

//		Data->MostKillsAmount = (float)(int)Find_Player(MostKillsID)->Kills;
		D_("7");
		Data->MostKillsName = Find_Player(MostKillsID)->PlayerName;
		D_("8");
		Data->BestKDAmount = (float)(int)Find_Player(BestKDID)->Kills / (int)Find_Player(BestKDID)->Deaths;
		D_("9");
		Data->BestKDName = Find_Player(BestKDID)->PlayerName;
		D_("10");
		Data->MVPScore = (float)Find_Player(HighestScoreID)->Score;
				D_("11");
		Data->MVPName = Find_Player(HighestScoreID)->PlayerName;
		D_("12");

		Functions::Create_Thread(Functions::Show_End_Game_Recs, (LPVOID)Data);
	} */
}

void AzazelBot::OnPlayerJoin(int PlayerID,const char *PlayerName)
{
	if (Find_Player(PlayerID)->PlayerName.Get_Length() > Settings::LimitNameLength)
	{
		//	IRC::SendC('a', "\x03%d[Notice]\x03 \x03%.2d%ls's name is longer than 20 characters and has been truncated.\x03\n", ColourStore::NoticeMsg, ColourStore::TextMsg, pName->m_Buffer);
		Find_Player(PlayerID)->PlayerName.TruncateRight(Find_Player(PlayerID)->PlayerName.Get_Length()-Settings::LimitNameLength);
		Functions::Console("pamsg %d Your name has been truncated to %d characters because it was longer than %d characters.", PlayerID, Settings::LimitNameLength, Settings::LimitNameLength);
	}

	Player::On_Player_Join(PlayerID);
	Functions::Check_Player(PlayerID);
	Functions::Create_Thread(Functions::Get_Host_Name, (LPVOID) PlayerID);

	if (Settings::ModsGameNick.Exists(PlayerName))
	{
		Functions::Create_Thread(Functions::Enforce_Auth_Protect, (LPVOID)PlayerID);
	}

	IRC::SendC(CHAN_PUBLIC, "%s%s has joined the game, fighting for team %s\n", GREEN, PlayerName, Get_Team(PlayerID) ? "GDI" : "Nod");
}

void AzazelBot::OnPlayerLeave(int PlayerID)
{
	IRC::SendC(CHAN_PUBLIC, "%s%S has left the game\n", GREEN, Find_Player(PlayerID)->PlayerName);
	Player::On_Player_Leave(PlayerID);
}

bool AzazelBot::OnRefill(GameObject *purchaser)
{
	return true;
}

int AzazelBot::OnPowerupPurchase(BaseControllerClass *base,GameObject *purchaser,unsigned int cost,unsigned int preset,const char *data)
{
	//Console_Output(__FUNCTION__ "\n");
	return -1;
}

int AzazelBot::OnVehiclePurchase(BaseControllerClass *base,GameObject *purchaser,unsigned int cost,unsigned int preset,const char *data)
{
	//Console_Output(__FUNCTION__ "\n");
	return -1;
}

int AzazelBot::OnCharacterPurchase(BaseControllerClass *base,GameObject *purchaser,unsigned int cost,unsigned int preset,const char *data)
{
	//Console_Output(__FUNCTION__ "\n");
	return -1;
}

void AzazelBot::OnThink()
{
	IRC::Think();
}

AzazelBot azazelBot;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &azazelBot;
}
